/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GProgressDialog;
import de.jave.image.GGreyscaleImage;
import de.jave.image.GImage;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JMOVExporter;
import de.jave.util.CancelAble;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;

public class BatchConversionThread
extends Thread
implements CancelAble {
    public boolean shallStop;
    protected String[] files;
    protected Image2AsciiAlgorithm algorithm;
    protected int resultWidth;
    protected double shapeFactor;
    protected boolean normalize;
    protected boolean invert;
    protected int highlight;
    protected int shadow;
    protected double gamma;
    protected double sharpen;
    protected int ditherMethode;
    protected int rotate;
    protected Frame parent;
    protected String directoryName;
    protected GProgressDialog progressDialog;
    protected JMOVExporter exporter;

    public BatchConversionThread(Frame frame, GProgressDialog gProgressDialog, String[] stringArray, String string, int n, double d, boolean bl, boolean bl2, int n2, int n3, double d2, double d3, int n4, int n5, Image2AsciiAlgorithm image2AsciiAlgorithm, JMOVExporter jMOVExporter) {
        this.exporter = jMOVExporter;
        this.parent = frame;
        this.files = stringArray;
        this.directoryName = string;
        this.resultWidth = n;
        this.shapeFactor = d;
        this.normalize = bl;
        this.invert = bl2;
        this.shadow = n3;
        this.highlight = n2;
        this.gamma = d2;
        this.sharpen = d3;
        this.ditherMethode = n4;
        this.algorithm = image2AsciiAlgorithm;
        this.rotate = n5;
        this.shallStop = false;
        this.progressDialog = gProgressDialog;
        this.setPriority(4);
    }

    public void doCancel() {
        this.shallStop = true;
    }

    public void run() {
        try {
            int n = 0;
            while (n < this.files.length) {
                block23: {
                    Thread.yield();
                    this.progressDialog.setProgress((double)n / (double)this.files.length);
                    Image image = Toolkit.getDefaultToolkit().getImage(this.files[n]);
                    MediaTracker mediaTracker = new MediaTracker(this.progressDialog);
                    mediaTracker.addImage(image, 0);
                    try {
                        mediaTracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int n2 = image.getWidth(this.progressDialog);
                    int n3 = image.getHeight(this.progressDialog);
                    int[] nArray = new int[n2 * n3];
                    PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n3, nArray, 0, n2);
                    try {
                        pixelGrabber.grabPixels();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Internal Error: " + interruptedException.toString());
                        break block23;
                    }
                    if ((pixelGrabber.getStatus() & 0x80) != 0) {
                        System.err.println("Internal Error: image fetch aborted or errored");
                    } else {
                        int n4;
                        Thread.yield();
                        GGreyscaleImage gGreyscaleImage = new GGreyscaleImage(nArray, n2, n3);
                        Thread.yield();
                        if (this.shallStop) {
                            this.aborted();
                            return;
                        }
                        if (this.rotate != 0) {
                            gGreyscaleImage = (GGreyscaleImage)gGreyscaleImage.rotate(this.rotate);
                        }
                        Thread.yield();
                        if (this.shallStop) {
                            this.aborted();
                            return;
                        }
                        n2 = gGreyscaleImage.getWidth();
                        n3 = gGreyscaleImage.getHeight();
                        Thread.yield();
                        double d = 0.52 * this.shapeFactor;
                        int n5 = this.resultWidth;
                        int n6 = n4 = (int)((double)n5 / (double)n2 * (double)n3 * d);
                        if (n4 < 1) {
                            n4 = 1;
                        }
                        if (n5 < 1) {
                            n5 = 1;
                        }
                        Thread.yield();
                        n4 *= this.algorithm.getVerticalPixelsPerChar();
                        n5 *= this.algorithm.getHorizontalPixelsPerChar();
                        if (this.shallStop) {
                            this.aborted();
                            return;
                        }
                        gGreyscaleImage = gGreyscaleImage.scale(n5, n4);
                        Thread.yield();
                        if (this.shallStop) {
                            this.aborted();
                            return;
                        }
                        Thread.yield();
                        gGreyscaleImage = gGreyscaleImage.convert(this.normalize, this.invert, this.gamma, this.highlight, this.shadow);
                        if (this.shallStop) {
                            this.aborted();
                            return;
                        }
                        this.algorithm.progress(0.2);
                        if (this.sharpen > 0.0) {
                            gGreyscaleImage = gGreyscaleImage.sharpen(this.sharpen);
                            this.algorithm.progress(0.25);
                        }
                        Thread.yield();
                        if (this.shallStop) {
                            this.aborted();
                            return;
                        }
                        GImage gImage = gGreyscaleImage;
                        if (this.ditherMethode != -1) {
                            gImage = gGreyscaleImage.dither(this.ditherMethode);
                        }
                        this.algorithm.progress(0.3);
                        Thread.yield();
                        if (this.shallStop) {
                            this.aborted();
                            return;
                        }
                        this.algorithm.progress(1.0);
                        CharacterPlate characterPlate = this.algorithm.convert(gImage);
                        this.exporter.setMaxFrameSize(new Dimension(this.resultWidth, n6));
                        if (n == 0) {
                            this.exporter.init();
                        }
                        this.exporter.setFrameSize(this.resultWidth, n6);
                        this.exporter.writeFrame(characterPlate.getContent());
                    }
                }
                ++n;
            }
            this.progressDialog.setProgress(1.0);
            this.exporter.close();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.progressDialog.dispose();
            this.exporter.emergencyCleanUp();
            new GErrorDialog(this.parent, "Image2Ascii - Batch Conversion", "Error exporting file: The result file is to big.").show();
            return;
        }
        catch (Throwable throwable) {
            this.progressDialog.dispose();
            this.exporter.emergencyCleanUp();
            new GErrorDialog(this.parent, "Image2Ascii - Batch Conversion", "Error exporting file", throwable).show();
            return;
        }
        this.progressDialog.dispose();
        String string = "Successfuly converted " + this.files.length + " images.";
        new GDialog(this.parent, "Image2Ascii - Batch Conversion", string, 3).show();
    }

    protected void aborted() throws Throwable {
        this.progressDialog.dispose();
        this.exporter.close();
        new GDialog(this.parent, "Image2Ascii - Batch Conversion", "Batch Conversion aborted.", 2).show();
    }
}

