/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image;

import de.jave.image.ValueRaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.MemoryImageSource;

public abstract class GImage
implements ValueRaster {
    protected int width;
    protected int height;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_RIGHT = 1;
    public static final int ROTATE_LEFT = 2;
    public static final int ROTATE_180 = 3;
    public static final String[] ROTATE_STR = new String[]{"none", "90 degrees right", "90 degrees left", "180 degrees"};
    protected static int seed;
    protected static final int A = 1291;
    protected static final int B = 4621;
    protected static final int M = 21870;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public final int getValueAt(int n, int n2) {
        return this.get(n, n2);
    }

    public abstract int get(int var1, int var2);

    public abstract void set(int var1, int var2, int var3);

    public abstract void paint(Graphics var1, int var2, int var3);

    public abstract int getNormalizingFactor();

    public abstract int getMaxPossibleValue();

    public void invert() {
        int n = this.getMaxPossibleValue();
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                this.set(n3, n2, n - this.get(n3, n2));
                ++n3;
            }
            ++n2;
        }
    }

    public MemoryImageSource getMemoryImageSource() {
        int[] nArray = new int[this.width * this.height];
        int n = this.getNormalizingFactor();
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                int n4 = this.get(n3, n2) * n;
                nArray[n2 * this.width + n3] = 0xFF000000 | (n4 & 0xFF) << 16 | (n4 & 0xFF) << 8 | n4 & 0xFF;
                ++n3;
            }
            ++n2;
        }
        return new MemoryImageSource(this.width, this.height, nArray, 0, this.width);
    }

    public MemoryImageSource getMemoryImageSource(Color color, Color color2) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color2.getRed();
        int n5 = color2.getGreen();
        int n6 = color2.getBlue();
        double d = n - n4;
        double d2 = n2 - n5;
        double d3 = n3 - n6;
        int[] nArray = new int[this.width * this.height];
        int n7 = this.getNormalizingFactor();
        int n8 = 0;
        while (n8 < this.height) {
            int n9 = 0;
            while (n9 < this.width) {
                double d4 = (double)(this.get(n9, n8) * n7) / 255.0;
                int n10 = (int)(d4 * d + (double)n4);
                int n11 = (int)(d4 * d2 + (double)n5);
                int n12 = (int)(d4 * d3 + (double)n6);
                nArray[n8 * this.width + n9] = 0xFF000000 | (n10 & 0xFF) << 16 | (n11 & 0xFF) << 8 | n12 & 0xFF;
                ++n9;
            }
            ++n8;
        }
        return new MemoryImageSource(this.width, this.height, nArray, 0, this.width);
    }

    protected final void seed() {
        seed = this.width * this.height;
    }

    protected static final int random(int n) {
        seed = (1291 * seed + 4621) % 21870;
        return seed % n;
    }

    public int[][] getPixels() {
        int n = this.getNormalizingFactor();
        int[][] nArray = new int[this.width][this.height];
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                nArray[n3][n2] = this.get(n3, n2) * n;
                ++n3;
            }
            ++n2;
        }
        return nArray;
    }

    protected abstract GImage createGImage(int var1, int var2);

    public abstract GImage getClone();

    public GImage rotate(int n) {
        GImage gImage = null;
        switch (n) {
            case 3: {
                gImage = this.createGImage(this.width, this.height);
                int n2 = 0;
                while (n2 < this.width) {
                    int n3 = 0;
                    while (n3 < this.height) {
                        gImage.set(this.width - n2 - 1, this.height - n3 - 1, this.get(n2, n3));
                        ++n3;
                    }
                    ++n2;
                }
                break;
            }
            case 2: {
                gImage = this.createGImage(this.height, this.width);
                int n4 = 0;
                while (n4 < this.width) {
                    int n5 = 0;
                    while (n5 < this.height) {
                        gImage.set(n5, this.width - n4 - 1, this.get(n4, n5));
                        ++n5;
                    }
                    ++n4;
                }
                break;
            }
            case 1: {
                gImage = this.createGImage(this.height, this.width);
                int n6 = 0;
                while (n6 < this.width) {
                    int n7 = 0;
                    while (n7 < this.height) {
                        gImage.set(this.height - n7 - 1, n6, this.get(n6, n7));
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
            case 0: {
                return this.getClone();
            }
        }
        return gImage;
    }
}

